/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.common;

import com.ibm.hsc.auiml.databeans.common.PIVirtualSlotBaseDataBean;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIVirtualEthernetDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.NumberComparator;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class PIVirtualEthernetPanelDataBean
extends PIVirtualSlotBaseDataBean
implements DataBean,
TaskActionListener {
    private static final String ADD_S = "VirtualEthernetPanel.AddVLANIDButton";
    private static final String REMOVE_S = "VirtualEthernetPanel.RemoveVLANIDButton";
    private static final String NEW_S = "VirtualEthernetPanel.NewVLANID";
    private static final String PORT_S = "VirtualEthernetPanel.PortVLANID";
    private static final String VLANLIST_S = "VirtualEthernetPanel.AdditionalVLANList";
    private static final String ISIEEE_S = "VirtualEthernetPanel.IsIEEE";
    private PIVirtualEthernetDataBean m_cimBean;
    private int m_portVLAN;
    private boolean m_isIEEE;
    private int m_maxVLANs;
    private int m_newVLAN;
    private List m_additionalVLANsSelection;
    private SortedSet m_additionalVLANs;
    private boolean m_isTrunk;
    private String m_macAddress;

    public PIVirtualEthernetPanelDataBean(PICECDataBean pICECDataBean, PIVirtualEthernetDataBean pIVirtualEthernetDataBean, SortedSet sortedSet) {
        super(pIVirtualEthernetDataBean, sortedSet);
        this.m_cimBean = pIVirtualEthernetDataBean;
        this.m_maxVLANs = pICECDataBean.getMaxVLANIDsPerPort().intValue();
        this.m_portVLAN = 1;
        this.m_isIEEE = false;
        this.m_isTrunk = false;
        this.m_newVLAN = 2;
        this.m_additionalVLANs = new TreeSet(new NumberComparator());
        this.m_additionalVLANsSelection = new ArrayList();
        this.m_macAddress = "";
    }

    public void setPortVLANID(double d) throws IllegalUserDataException {
        this.m_portVLAN = (int)Math.rint(d);
    }

    public double getPortVLANID() {
        return this.m_portVLAN;
    }

    public void setIEEEGroupSelection(String[] stringArray) throws IllegalUserDataException {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!ISIEEE_S.equals(stringArray[i])) continue;
                this.m_isIEEE = true;
                return;
            }
        }
        this.m_isIEEE = false;
    }

    public String[] getIEEEGroupSelection() {
        String[] stringArray = null;
        stringArray = this.m_isIEEE ? new String[]{ISIEEE_S} : new String[]{};
        return stringArray;
    }

    public void setMaxVLANIDs(String string) throws IllegalUserDataException {
    }

    public String getMaxVLANIDs() {
        return "" + this.m_maxVLANs;
    }

    public void setNewVLANID(double d) throws IllegalUserDataException {
        this.m_newVLAN = (int)Math.rint(d);
    }

    public double getNewVLANID() {
        return this.m_newVLAN;
    }

    public void setAdditionalVLANsList(ValueDescriptor[] valueDescriptorArray) throws IllegalUserDataException {
    }

    public ValueDescriptor[] getAdditionalVLANsList() {
        ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[this.m_additionalVLANs.size()];
        Iterator iterator = this.m_additionalVLANs.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            valueDescriptorArray[n] = new ValueDescriptor(string, string);
            ++n;
        }
        return valueDescriptorArray;
    }

    public void setAdditionalVLANsSelection(ValueDescriptor[] valueDescriptorArray) throws IllegalUserDataException {
        this.m_additionalVLANsSelection.clear();
        for (int i = 0; i < valueDescriptorArray.length; ++i) {
            this.m_additionalVLANsSelection.add(new UnsignedInt16(valueDescriptorArray[i].getTitle()));
        }
    }

    public ValueDescriptor[] getAdditionalVLANsSelection() {
        ValueDescriptor[] valueDescriptorArray = new ValueDescriptor[this.m_additionalVLANsSelection.size()];
        Iterator iterator = this.m_additionalVLANsSelection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            valueDescriptorArray[n] = new ValueDescriptor(string, string);
            ++n;
        }
        return valueDescriptorArray;
    }

    public void setTrunk(boolean bl) throws IllegalUserDataException {
        this.m_isTrunk = bl;
    }

    public boolean isTrunk() {
        return this.m_isTrunk;
    }

    public void setMACAddress(String string) throws IllegalUserDataException {
    }

    public String getMACAddress() {
        return this.m_macAddress;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        UnsignedInt16[] unsignedInt16Array;
        UnsignedInt8 unsignedInt8;
        UnsignedInt8 unsignedInt82;
        super.load();
        UnsignedInt16 unsignedInt16 = this.m_cimBean.getPvid();
        if (unsignedInt16 != null) {
            this.m_portVLAN = unsignedInt16.intValue();
        }
        if ((unsignedInt82 = this.m_cimBean.getIeee()) != null) {
            this.m_isIEEE = unsignedInt82.intValue() != 0;
        }
        if ((unsignedInt8 = this.m_cimBean.getTrunk()) != null) {
            this.m_isTrunk = unsignedInt8.intValue() != 0;
        }
        if ((unsignedInt16Array = this.m_cimBean.getAdditionalVids()) != null && unsignedInt16Array.length != 0) {
            this.m_additionalVLANs.clear();
            for (int i = 0; i < unsignedInt16Array.length; ++i) {
                this.m_additionalVLANs.add(unsignedInt16Array[i]);
            }
        }
        this.m_macAddress = this.m_cimBean.getMacAddress();
        if (this.m_macAddress == null) {
            this.m_macAddress = "";
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        super.verifyChanges();
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(this.m_portVLAN);
        this.m_additionalVLANs.remove(unsignedInt16);
        if (this.m_additionalVLANs.size() > this.m_maxVLANs - 1) {
            String string = HSCResourceBundleUtil.getMessage("ProfileBundle", "TOO_MANY_VIDS", "NLS_MESSAGE_NOT_FOUND", new String[]{new Integer(this.m_slotNumber).toString(), new Integer(this.m_additionalVLANs.size() - this.m_maxVLANs).toString()});
            throw new IllegalUserDataException(string);
        }
    }

    public void save() {
        super.save();
        this.m_cimBean.setPvid(new UnsignedInt16(this.m_portVLAN));
        this.m_cimBean.setIeee(this.m_isIEEE ? new UnsignedInt8(1) : new UnsignedInt8(0));
        if (this.m_isIEEE) {
            UnsignedInt16[] unsignedInt16Array = new UnsignedInt16[this.m_additionalVLANs.size()];
            Iterator iterator = this.m_additionalVLANs.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                unsignedInt16Array[n] = (UnsignedInt16)iterator.next();
                ++n;
            }
            this.m_cimBean.setAdditionalVids(unsignedInt16Array);
        } else {
            this.m_cimBean.setAdditionalVids(new UnsignedInt16[0]);
        }
        this.m_cimBean.setTrunk(this.m_isTrunk ? new UnsignedInt8(1) : new UnsignedInt8(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(TaskActionEvent taskActionEvent) {
        UserTaskManager userTaskManager = (UserTaskManager)taskActionEvent.getSource();
        if (ADD_S.equals(taskActionEvent.getActionCommand())) {
            try {
                userTaskManager.storeElement(PORT_S);
                userTaskManager.storeElement(NEW_S);
            }
            catch (IllegalUserDataException illegalUserDataException) {
                return;
            }
            UnsignedInt16 unsignedInt16 = new UnsignedInt16(this.m_portVLAN);
            UnsignedInt16 unsignedInt162 = new UnsignedInt16(this.m_newVLAN);
            if (this.m_additionalVLANs.size() < this.m_maxVLANs - 1) {
                try {
                    System.out.println("Add button pressed.  Value = " + unsignedInt162);
                    if (!this.m_additionalVLANs.add(unsignedInt162)) return;
                    userTaskManager.refreshElement(VLANLIST_S);
                    return;
                }
                catch (IllegalUserDataException illegalUserDataException) {
                    return;
                }
            } else {
                String string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "TOO_MANY_VLAN_IDS", null, new String[]{new Integer(this.m_slotNumber).toString(), new Integer(this.m_maxVLANs - 1).toString()});
                new TaskMessage(userTaskManager, string, 1).invoke();
            }
            return;
        }
        if (REMOVE_S.equals(taskActionEvent.getActionCommand())) {
            System.out.println("Remove button pressed.");
            userTaskManager.storeElement(VLANLIST_S);
            if (this.m_additionalVLANsSelection.size() <= 0) return;
            this.m_additionalVLANs.removeAll(this.m_additionalVLANsSelection);
            userTaskManager.refreshElement(VLANLIST_S);
            return;
        } else {
            System.out.println("Other action event: " + taskActionEvent);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("VirtualEthernetPanelDataBean [ ");
        stringBuffer.append("SlotNumber = ").append(this.m_slotNumber).append(", ");
        stringBuffer.append("IsRequired = ").append(this.m_isRequired).append(", ");
        stringBuffer.append("IsTrunk = ").append(this.m_isTrunk).append(", ");
        stringBuffer.append("PortVLANID = ").append(this.m_portVLAN).append(", ");
        stringBuffer.append("IsIEEE = ").append(this.m_isIEEE).append(", ");
        stringBuffer.append("MaxVLANs = ").append(this.m_maxVLANs).append(", ");
        stringBuffer.append("NewVLAN = ").append(this.m_newVLAN).append(", ");
        stringBuffer.append("AdditionalVLANs =");
        if (this.m_additionalVLANs == null) {
            stringBuffer.append("null ");
        } else if (this.m_additionalVLANs.size() > 0) {
            Iterator iterator = this.m_additionalVLANs.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringBuffer.append(" ").append(iterator.next());
                ++n;
            }
        }
        stringBuffer.append(", ");
        stringBuffer.append("MACAddress = ").append(this.m_macAddress).append("]");
        return stringBuffer.toString();
    }
}

